// NOBF_ORA8.h

#if !defined _NOBF_ORA8_H_
#define _NOBF_ORA8_H_

#include "stdafx.h"
#include "CSSBFC.h"
#include "oci.h"
#include "ocidem.h"

#if (_NOBF_ORA8_ == TRUE)

// static variables
static BOOL bLoggedOn = FALSE;
static OCIEnv* pMasterEnvironment;
static OCIError* pMasterError;
static OCIServer* pMasterServer;
static OCISvcCtx* pMasterServerContext;
static OCISession* pMasterSession;

class AFX_EXT_CLASS CSQLObject : public CObject
{
	public:

		void ResetErrorStatus (void);
		void HandleError (CString szErrorMsg);
		void AddIgnoreError (int nErrorNumber);
		void RemoveIgnoreError (int nErrorNumber);
		int GetLastError ();
};

class AFX_EXT_CLASS COracle8Driver : public CSQLObject
{
	public:

		COracle8Driver (void);
		~COracle8Driver (void);
		BOOL DatabaseLogon (void);
		BOOL DatabaseLogoff (void);
		OCIEnv *GetOCIEnvironment (void);
		OCISession *GetOCISession (void);
		OCISvcCtx *GetOCIServerContext (void);
		OCIError *GetOCIError (void);
		void HandleError (WORD wStatus, OCIError* pError);
};

#endif

#endif
